local player = ...

local valid = {}

-- ------------------------------------------
-- First, check for modes not supported by GrooveStats.

-- GrooveStats only supports dance for now (not pump, techno, etc.)
valid[1] = GAMESTATE:GetCurrentGame():GetName() == "dance"

-- GrooveStats does not support dance-solo (i.e. 6-panel dance like DDR Solo 4th Mix)
-- https://en.wikipedia.org/wiki/Dance_Dance_Revolution_Solo
valid[2] = GAMESTATE:GetCurrentStyle():GetName() ~= "solo"

-- GrooveStats does rank Marathons from ITG1, ITG2, and ITG Home
-- but there isn't QR support at this time.
valid[3] = not GAMESTATE:IsCourseMode()

-- GrooveStats was made with ITG settings in mind.
-- "Game Modes" no longer exist in this theme, but there are external checks that will just remove the pane entirely
-- if ITG settings were not used in gameplay (I think this makes sense)
---- valid[4] = (SL.Global.GameMode == "ITG" or SL.Global.GameMode == "FA+")

-- ------------------------------------------
-- Next, check global Preferences that would invalidate the score.

-- TimingWindowScale and LifeDifficultyScale are a little confusing. I am not supporting changing these in the
-- options menu, but should still do the check here in case someone does change the preferences in some way.
--
-- I don't know the history here, but I suspect these preferences are holdovers from SM3.9 when
-- themes were just visual skins and core mechanics like TimingWindows and Life scaling could only
-- be handled by the SM engine.
--
-- 4 (1, internally) is considered standard for ITG.
-- GrooveStats expects players to have both these set to 4 (1, internally).

-- validate ITG timing and lifebar metrics
-- really anyone could just change the values used in the check here but I might as well cover as much ground as I can
	
local itgprefs_sl = SL.Preferences.ITG
local itgwindows_wf = WF.ITGTimingWindows
local tws = PREFSMAN:GetPreference("TimingWindowScale")
local twa = itgprefs_sl.TimingWindowAdd

valid[4] = (itgprefs_sl.TimingWindowSecondsW1 * tws + twa == 0.023 and itgwindows_wf[1] == 0.023) and
		   (itgprefs_sl.TimingWindowSecondsW2 * tws + twa == 0.0445 and itgwindows_wf[2] == 0.0445) and
		   (itgprefs_sl.TimingWindowSecondsW3 * tws + twa == 0.1035 and itgwindows_wf[3] == 0.1035) and
		   (itgprefs_sl.TimingWindowSecondsW4 * tws + twa == 0.1365 and itgwindows_wf[4] == 0.1365) and
		   (itgprefs_sl.TimingWindowSecondsW5 * tws + twa == 0.1815 and itgwindows_wf[5] == 0.1815)

local life_itg = WF.ITGLifeChanges
valid[5] = life_itg[1] == 0.008 and life_itg[2] == 0.008 and life_itg[3] == 0.004 and life_itg[4] == 0 and
		   life_itg[5] == -0.05 and life_itg[6] == -0.1 and life_itg[7] == 0.008 and life_itg[8] == -0.08 and
		   life_itg[9] == -0.05

-- ------------------------------------------
-- Finally, check player-specific modifiers used during this song that would invalidate the score.

-- get playeroptions so we can check mods the player used
local po = GAMESTATE:GetPlayerState(player):GetPlayerOptions("ModsLevel_Preferred")

-- Check FA+ options
valid[6] = ThemePrefs.Get("GSAllowFAPlus") or (SL[ToEnumShortString(player)].ActiveModifiers.FAPlus == 0)

-- adding/removing notes, along with changing the fail type, are not supported in this theme. but these
-- validations might as well still be here for good measure.

-- score is invalid if notes were removed
valid[7] = not (
	   po:Little()  or po:NoHolds() or po:NoStretch()
	or po:NoHands() or po:NoJumps() or po:NoFakes()
	or po:NoLifts() or po:NoQuads() or po:NoRolls()
)

-- score is invalid if notes were added
valid[8] = not (
	   po:Wide() or po:Skippy() or po:Quick()
	or po:Echo() or po:BMRize() or po:Stomp()
	or po:Big()
)

-- only FailTypes "Immediate" and "ImmediateContinue" are valid for GrooveStats
valid[9] = (po:FailSetting() == "FailType_Immediate" or po:FailSetting() == "FailType_ImmediateContinue")

-- ------------------------------------------
-- return the entire table so that we can let the player know which settings,
-- if any, prevented their score from being valid for GrooveStats

return valid